// GLCamera.h: interface for the GLCamera class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GLCAMERA_H__B3075049_15E9_4C6F_A6C8_988A24B2FC26__INCLUDED_)
#define AFX_GLCAMERA_H__B3075049_15E9_4C6F_A6C8_988A24B2FC26__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Vector.h"

/*
 * 3D Camera class. Encapsulates OpenGL camera control for both orbiting and moving camera.
 * Author: Ryan Holmes
 * E-mail: Ryan <dot> Holmes <at> asu <dot> edu
 */

class GLCamera  
{
public:
	GLCamera();
	virtual ~GLCamera();

	GLdouble aspect;
	GLdouble viewAngle;
	GLdouble nearPlane;
	GLdouble farPlane;
	GLdouble viewWidth;
	GLdouble viewHeight;
	
	double speed;

	Vector fromPoint;
	Vector atPoint;
	Vector upVector;

	void setGLView(void);
	void setGLViewModel(void);
	void setViewport(int x, int y, int width, int height);
	void zoom(double amount);
	void pan(double downDegrees, double rightDegrees);
	void turn(double downDegrees, double rightDegrees);
	void changeSpeed(double percent);
	void setSpeed(double speed);
	void move(bool forward);
};

#endif // !defined(AFX_GLCAMERA_H__B3075049_15E9_4C6F_A6C8_988A24B2FC26__INCLUDED_)
