// OpenGLSkeletonDoc.cpp : implementation of the COpenGLSkeletonDoc class
//

#include "stdafx.h"
#include "OpenGLSkeleton.h"

#include "OpenGLSkeletonDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COpenGLSkeletonDoc

IMPLEMENT_DYNCREATE(COpenGLSkeletonDoc, CDocument)

BEGIN_MESSAGE_MAP(COpenGLSkeletonDoc, CDocument)
	//{{AFX_MSG_MAP(COpenGLSkeletonDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenGLSkeletonDoc construction/destruction
/*
 * OpenGLSkeleton is an example MFC/Visual C++ skeleton program. It was first written to be
 * a starting point for students in the CSE470 (Introduction to Computer Graphics) class at
 * Arizona State University. I have extended it slightly since then and included two helper
 * classes that make the camera easy to control.
 * Please do not claim to have written this code, or alter it and claim that I have written your
 * altered version. Other than that, please feel free to use, adapt, and learn from this code. 
 * Author: Ryan Holmes
 * E-mail: Ryan <dot> Holmes <at> asu <dot> edu
 */

COpenGLSkeletonDoc::COpenGLSkeletonDoc()
{
	// Initialize the display list to 0. 0 is not a valid display list,
	// so this is similar to setting a pointer to NULL to indicate that
	// it contains nothing.
	displayList = 0;

	// Initialize the subdivisions to one per quarter of the circle
	subdivisions = 1;
	// Initialize the squares to meet at the edges instead of to be inset
	insetSquares = false;
}

COpenGLSkeletonDoc::~COpenGLSkeletonDoc()
{
	// If a display list has been created, delete it now.
	if (displayList != 0) {
		::glDeleteLists(displayList, 1);
		displayList = 0;
	}
}

BOOL COpenGLSkeletonDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// COpenGLSkeletonDoc serialization

void COpenGLSkeletonDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// COpenGLSkeletonDoc diagnostics

#ifdef _DEBUG
void COpenGLSkeletonDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void COpenGLSkeletonDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COpenGLSkeletonDoc commands

void COpenGLSkeletonDoc::setSubdivisions(int s)
{
	// Only allow subdivisions between 1 and 128. The lower bound is
	// absolute, because the formulas no longer work at or below 0.
	// The upper bound is arbitrary, but beyond a point it becomes
	// difficult to see.
	if (s > 0 && s <= 128) {
		subdivisions = s;
		buildList();
	}
}

void COpenGLSkeletonDoc::setInset(bool i)
{
	insetSquares = i;
	buildList();
}

GLuint COpenGLSkeletonDoc::buildList() {

	// If no display list has been created, allocate it now.
	// If one already has been created, we can re-use its ID
	// with the new creation parameter. Re-using it in this way
	// automatically deletes the prior list.
	if (displayList == 0) {
		// Get a new list ID from the OpenGL list ID generation system.
		displayList = ::glGenLists(1);
	}
	// Create a new list with that ID
	::glNewList(displayList, GL_COMPILE);

	// The subdivisions parameter gives the number of subdivisions
	// per quarter of the loop. The number of quads is four times
	// the subdivisions.
	int quadsPerLoop = subdivisions * 4;
	// Each quad thus takes up one quadsPerLoop-th of 360 degrees
	float degreesPerQuad = 360.0f / (float)quadsPerLoop;
	// Convert to radians to use sin() and cos()
	double radiansPerQuad = degreesPerQuad * (3.14159265 / 180.0);
	// The quads are centered around the axis, so the size is actually
	// dependent upon half of the total angle the quad spans.
	double squareSize = sin(radiansPerQuad / 2.0);
	double squareDistance = cos(radiansPerQuad / 2.0);

	// By scaling the size we get a smaller protusion above and below
	// the axis. This gives an inset square.
	if (insetSquares) {
		squareSize *= .8;
	}

	// Create the first loop of quads
	for (int i = 0; i < quadsPerLoop; i++) {
		// Save the current transform matrix
		::glPushMatrix();
		// Rotate around the y-axis by each multiple of 30 degrees
		::glRotatef((float)i * degreesPerQuad, 0, 1, 0);

		// Begin a sequence of quadrilaterals. The "sequence" consists
		// of a single quad only. We have to do each quad in its own
		// begin/end sequence because we are doing glRotate between
		// quads, and this command is not valid between a begin/end pair.
		::glBegin(GL_QUADS);

		// Assign a normal along the rotated x-axis. This normal will
		// be the normal of every vertex specified hereafter, until a new
		// normal is assigned.
		::glNormal3d(1.0, 0.0, 0.0);
		// Specify the four points of the quadrilateral that will have
		// that normal.
		::glVertex3d(squareDistance, -squareSize, -squareSize);
		::glVertex3d(squareDistance,  squareSize, -squareSize);
		::glVertex3d(squareDistance,  squareSize,  squareSize);
		::glVertex3d(squareDistance, -squareSize,  squareSize);

		// End the sequence of quadrilaterals
		::glEnd();

		// Restore the unrotated transform matrix
		::glPopMatrix();
	}
	// Now do a loop around the z-axis. Skip the first and the middle,
	// because these have already been sent.
	i = 1;
	while (i < quadsPerLoop) {
		::glPushMatrix();
		::glRotatef((float)i * degreesPerQuad, 0, 0, 1);
		::glBegin(GL_QUADS);
		::glNormal3d(1.0, 0.0, 0.0);
		::glVertex3d(squareDistance, -squareSize, -squareSize);
		::glVertex3d(squareDistance,  squareSize, -squareSize);
		::glVertex3d(squareDistance,  squareSize,  squareSize);
		::glVertex3d(squareDistance, -squareSize,  squareSize);
		::glEnd();
		::glPopMatrix();
		i++;
		if (i == (quadsPerLoop / 2)) {
			i++;
		}
	}
	if (subdivisions > 1) {
		// Now do a final loop around the x-axis. Skip every subdivisions-ith because these
		// have already been sent. If we're only doing 1 subdivision, all six sides have already
		// been drawn, so skip this loop entirely.
		// Note that because we are rotating around x we must specify a slightly
		// different square to draw, and a different normal.
		i = 1;
		while (i < quadsPerLoop) {
			::glPushMatrix();
			::glRotatef((float)i * degreesPerQuad, 1, 0, 0);
			::glBegin(GL_QUADS);
			::glNormal3d(0.0, 1.0, 0.0);
			::glVertex3d(-squareSize, squareDistance,  squareSize);
			::glVertex3d( squareSize, squareDistance,  squareSize);
			::glVertex3d( squareSize, squareDistance, -squareSize);
			::glVertex3d(-squareSize, squareDistance, -squareSize);
			::glEnd();
			::glPopMatrix();
			i++;
			if (i % subdivisions == 0) {
				i++;
			}
		}
	}

	// End the display list. This step is very important. It tells the
	// OpenGL driver that everything we have done since the beginList
	// should be compiled into a display list and that further commands
	// should be acted upon, not saved into a list.
	::glEndList();

	return displayList;
}