// OpenGLSkeletonView.h : interface of the COpenGLSkeletonView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENGLSKELETONVIEW_H__BEC568DD_4DF2_4423_B6FC_553A78165EF4__INCLUDED_)
#define AFX_OPENGLSKELETONVIEW_H__BEC568DD_4DF2_4423_B6FC_553A78165EF4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SubdivisionDialog.h"
#include "GLCamera.h"
/*
 * OpenGLSkeleton is an example MFC/Visual C++ skeleton program. It was first written to be
 * a starting point for students in the CSE470 (Introduction to Computer Graphics) class at
 * Arizona State University. I have extended it slightly since then and included two helper
 * classes that make the camera easy to control.
 * Please do not claim to have written this code, or alter it and claim that I have written your
 * altered version. Other than that, please feel free to use, adapt, and learn from this code. 
 * Author: Ryan Holmes
 * E-mail: Ryan <dot> Holmes <at> asu <dot> edu
 */

class COpenGLSkeletonView : public CView
{
protected: // create from serialization only
	COpenGLSkeletonView();
	DECLARE_DYNCREATE(COpenGLSkeletonView)

// Attributes
public:
	COpenGLSkeletonDoc* GetDocument();

	CClientDC* m_pDC;
	HGLRC m_hRC;

	COLORREF bgColor;					// The clear color for the window

	bool lMouseDown;					// True if left mouse button is down
	bool rMouseDown;					// True if right mouse button is down
	CPoint lastMousePoint;				// Last mouse point referenced.

	GLCamera camera;					// Encapsulation of camera controls

	void updateNearFar();				// Adjust the camera to frame the target object well

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenGLSkeletonView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COpenGLSkeletonView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(COpenGLSkeletonView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnToolsBGColor();
	afx_msg void OnToolsInset();
	afx_msg void OnUpdateToolsInset(CCmdUI* pCmdUI);
	afx_msg void OnToolsSubdivisions();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnToolsDecreaseSubdivisions();
	afx_msg void OnUpdateToolsDecreaseSubdivisions(CCmdUI* pCmdUI);
	afx_msg void OnToolsIncreaseSubdivisions();
	afx_msg void OnUpdateToolsIncreaseSubdivisions(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in OpenGLSkeletonView.cpp
inline COpenGLSkeletonDoc* COpenGLSkeletonView::GetDocument()
   { return (COpenGLSkeletonDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPENGLSKELETONVIEW_H__BEC568DD_4DF2_4423_B6FC_553A78165EF4__INCLUDED_)
