// OpenGLSkeletonView.h : interface of the COpenGLSkeletonView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENGLSKELETONVIEW_H__BEC568DD_4DF2_4423_B6FC_553A78165EF4__INCLUDED_)
#define AFX_OPENGLSKELETONVIEW_H__BEC568DD_4DF2_4423_B6FC_553A78165EF4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GLCamera.h"

class COpenGLSkeletonView : public CView
{
protected: // create from serialization only
	COpenGLSkeletonView();
	DECLARE_DYNCREATE(COpenGLSkeletonView)

// Attributes
public:
	COpenGLSkeletonDoc* GetDocument();

	CClientDC* m_pDC;
	HGLRC m_hRC;
	RECT m_window_size;					// The size of the OpenGL window
	GLfloat m_far_plane;				// The back clipping plane
	GLfloat m_near_plane;				// The front clipping plane

	COLORREF bgColor;					// The clear color for the window
	GLfloat aspect;						// The aspect ratio for the window

	bool lMouseDown;					// True if left mouse button is down
	bool rMouseDown;					// True if right mouse button is down
	CPoint lastClickPoint;				// Last mouse point referenced.

	GLCamera camera;					// Encapsulation of camera controls

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenGLSkeletonView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COpenGLSkeletonView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(COpenGLSkeletonView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in OpenGLSkeletonView.cpp
inline COpenGLSkeletonDoc* COpenGLSkeletonView::GetDocument()
   { return (COpenGLSkeletonDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPENGLSKELETONVIEW_H__BEC568DD_4DF2_4423_B6FC_553A78165EF4__INCLUDED_)
